
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Document(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getDocumentContent(self,documentListName, documentId):
		""" Retrieve the content associated with a document, such as a product image or PDF specifications file, by supplying the document ID.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
		
		Returns:
			| Stream 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}/content", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def transformDocumentContent(self,documentListName, documentId, width = None, height = None, max = None, maxWidth = None, maxHeight = None, crop = None, quality = None):
		""" documentlists-documents Get TransformDocumentContent description DOCUMENT_HERE 
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
			| width (int) - 
			| height (int) - 
			| max (int) - 
			| maxWidth (int) - 
			| maxHeight (int) - 
			| crop (string) - 
			| quality (int) - 
		
		Returns:
			| Stream 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}/transform?width={width}&height={height}&maxWidth={maxWidth}&maxHeight={maxHeight}&crop={crop}&quality={quality}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("crop", crop);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("height", height);
		url.formatUrl("max", max);
		url.formatUrl("maxHeight", maxHeight);
		url.formatUrl("maxWidth", maxWidth);
		url.formatUrl("quality", quality);
		url.formatUrl("width", width);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getDocument(self,documentListName, documentId, includeInactive = False, responseFields = None):
		""" Retrieves a document within the specified document list.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
			| includeInactive (bool) - 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Document 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}?includeInactive={includeInactive}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("includeInactive", includeInactive);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getDocuments(self,documentListName, filter = None, sortBy = None, pageSize = None, startIndex = None, includeInactive = False, responseFields = None):
		""" Retrieves a collection of documents according to any filter and sort criteria.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| sortBy (string) - The property by which to sort results and whether the results appear in ascending (a-z) order, represented by ASC or in descending (z-a) order, represented by DESC. The sortBy parameter follows an available property. For example: "sortBy=productCode+asc"
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| includeInactive (bool) - 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents?filter={filter}&sortBy={sortBy}&pageSize={pageSize}&startIndex={startIndex}&includeInactive={includeInactive}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("filter", filter);
		url.formatUrl("includeInactive", includeInactive);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createDocument(self,document, documentListName, responseFields = None):
		""" Creates a new document in an defined document list.
		
		Args:
			| document(document) - The document properties that define the content used by the content management system (CMS).
			| documentListName (string) - Name of content documentListName to delete
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Document 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(document).execute();
		return self.client.result();

	
		
	def updateDocumentContent(self,stream, documentListName, documentId, contentType = None):
		""" Updates the content associated with a document, such as a product image or PDF specifications file, by supplying the document ID.
		
		Args:
			| stream(stream) - Data stream that delivers information. Used to input and output data.
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
			| contentType (string) - set content type of the data uploaded|
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}/content", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		self.client.withResourceUrl(url).withBody(stream).withContentType(contentType).execute();

	
		
	def updateDocument(self,document, documentListName, documentId, responseFields = None):
		""" Updates a document in a document list.
		
		Args:
			| document(document) - The document properties that define the content used by the content management system (CMS).
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Document 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(document).execute();
		return self.client.result();

	
		
	def deleteDocument(self,documentListName, documentId):
		""" Deletes a specific document based on the specified document ID.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		self.client.withResourceUrl(url).execute();

	
		
	def deleteDocumentContent(self,documentListName, documentId):
		""" Deletes the content associated with a document, such as a product image or PDF specification, by supplying the document ID.
		
		Args:
			| documentListName (string) - Name of content documentListName to delete
			| documentId (string) - Unique identifier for a document, used by content and document calls. Document IDs are associated with document types, document type lists, sites, and tenants.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documentlists/{documentListName}/documents/{documentId}/content", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("documentId", documentId);
		url.formatUrl("documentListName", documentListName);
		self.client.withResourceUrl(url).execute();

	
	
	