
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class OrderAttribute(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getOrderAttributes(self,orderId):
		""" Retrieves a list of the attributes defined for the order specified in the request.
		
		Args:
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of OrderAttribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/attributes", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createOrderAttributes(self,orderAttributes, orderId):
		""" Applies a list of attributes to the order specified in the request and defines a value for each attribute in the request body.
		
		Args:
			| orderAttributes(array|orderAttributes) - Properties of an attribute applied to an order.
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of OrderAttribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/attributes", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).withBody(orderAttributes).execute();
		return self.client.result();

	
		
	def updateOrderAttributes(self,orderAttributes, orderId, removeMissing = False):
		""" Updates one or more properties of an attribute defined for the order specified in the request.
		
		Args:
			| orderAttributes(array|orderAttributes) - Properties of an attribute applied to an order.
			| orderId (string) - Unique identifier of the order.
			| removeMissing (bool) - If true, the operation removes missing properties so that the updated order attributes will not show properties with a null value.
		
		Returns:
			| array of OrderAttribute 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/attributes?removeMissing={removeMissing}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("removeMissing", removeMissing);
		self.client.withResourceUrl(url).withBody(orderAttributes).execute();
		return self.client.result();

	
	
	