
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Order(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getOrders(self,startIndex = None, pageSize = None, sortBy = None, filter = None, q = None, qLimit = None, responseFields = None):
		""" Retrieves a list of orders according to any specified filter criteria and sort options.
		
		Args:
			| startIndex (int) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| sortBy (string) - 
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| q (string) - A list of order search terms (not phrases) to use in the query when searching across order number and the name or email of the billing contact. When entering, separate multiple search terms with a space character.
			| qLimit (int) - The maximum number of search results to return in the response. You can limit any range between 1-100.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| OrderCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&q={q}&qLimit={qLimit}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("q", q);
		url.formatUrl("qLimit", qLimit);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getAvailableActions(self,orderId):
		""" Retrieves the actions available to perform for an order based on its current status.
		
		Args:
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of string 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/actions", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getTaxableOrders(self,orderId):
		""" Retrieves an order for the purpose of splitting it into multiple taxable orders in order to fulfill the order in multiple locations.
		
		Args:
			| orderId (string) - Unique identifier of the order.
		
		Returns:
			| array of TaxableOrder 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/taxableorders", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getOrder(self,orderId, draft = False, responseFields = None):
		""" Retrieves the details of an order specified by the order ID.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| draft (bool) - If true, retrieve the draft version of the order, which might include uncommitted changes to the order or its components.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}?draft={draft}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("draft", draft);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createOrderFromCart(self,cartId, responseFields = None):
		""" Creates a new order from an existing cart when the customer chooses to proceed to checkout.
		
		Args:
			| cartId (string) - Identifier of the cart to delete.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/?cartId={cartId}&responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("cartId", cartId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createOrder(self,order, responseFields = None):
		""" Creates a new order for no-cart quick-ordering scenarios.
		
		Args:
			| order(order) - Properties of an order, including its components.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(order).execute();
		return self.client.result();

	
		
	def performOrderAction(self,action, orderId, responseFields = None):
		""" Perform the specified action for an order. The actions you can perform depend on the current status of the order.
		
		Args:
			| action(action) - The action to perform for the order.
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/actions?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(action).execute();
		return self.client.result();

	
		
	def processDigitalWallet(self,digitalWallet, orderId, digitalWalletType, responseFields = None):
		""" commerce-orders Put ProcessDigitalWallet description DOCUMENT_HERE 
		
		Args:
			| digitalWallet(digitalWallet) - Mozu.CommerceRuntime.Contracts.Orders.DigitalWallet ApiType DOCUMENT_HERE 
			| orderId (string) - Unique identifier of the order.
			| digitalWalletType (string) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/digitalWallet/{digitalWalletType}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("digitalWalletType", digitalWalletType);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(digitalWallet).execute();
		return self.client.result();

	
		
	def updateOrderDiscount(self,discount, orderId, discountId, updateMode = None, version = None, responseFields = None):
		""" Update the properties of a discount applied to an order.
		
		Args:
			| discount(discount) - Properties of all applied discounts for an associated cart, order, or product. 
			| orderId (string) - Unique identifier of the order.
			| discountId (int) - Unique identifier of the discount. System-supplied and read only.
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - System-supplied integer that represents the current version of the order, which prevents users from unintentionally overriding changes to the order. When a user performs an operation for a defined order, the system validates that the version of the updated order matches the version of the order on the server. After the operation completes successfully, the system increments the version number by one.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/discounts/{discountId}?updatemode={updateMode}&version={version}&responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("discountId", discountId);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(discount).execute();
		return self.client.result();

	
		
	def deleteOrderDraft(self,orderId, version = None):
		""" Deletes the current draft version of the order, which also deletes any uncommitted changes made to the order in draft mode.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| version (string) - Determines whether or not to check versioning of items for concurrency purposes.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/draft?version={version}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).execute();

	
		
	def resendOrderConfirmationEmail(self,action, orderId):
		""" commerce-orders Put ResendOrderConfirmationEmail description DOCUMENT_HERE 
		
		Args:
			| action(action) - The action to perform for the order.
			| orderId (string) - Unique identifier of the order.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/email/resend", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		self.client.withResourceUrl(url).withBody(action).execute();

	
		
	def changeOrderUserId(self,orderId, responseFields = None):
		""" Updates the user ID of the shopper who placed the order to the current user.
		
		Args:
			| orderId (string) - Unique identifier of the order.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}/users?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def updateOrder(self,order, orderId, updateMode = None, version = None, responseFields = None):
		""" Updates the specified order when additional order information, such as shipping or billing information, is modified during the checkout process.
		
		Args:
			| order(order) - Properties of an order, including its components.
			| orderId (string) - Unique identifier of the order.
			| updateMode (string) - Specifies whether to update the original order, update the order in draft mode, or update the order in draft mode and then commit the changes to the original. Draft mode enables users to make incremental order changes before committing the changes to the original order. Valid values are "ApplyToOriginal," "ApplyToDraft," or "ApplyAndCommit."
			| version (string) - System-supplied integer that represents the current version of the order, which prevents users from unintentionally overriding changes to the order. When a user performs an operation for a defined order, the system validates that the version of the updated order matches the version of the order on the server. After the operation completes successfully, the system increments the version number by one.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| Order 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/orders/{orderId}?updatemode={updateMode}&version={version}&responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("orderId", orderId);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("updateMode", updateMode);
		url.formatUrl("version", version);
		self.client.withResourceUrl(url).withBody(order).execute();
		return self.client.result();

	
	
	