
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class CouponSet(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getCouponSets(self,startIndex = None, pageSize = None, sortBy = None, filter = None, includeCounts = False, responseFields = None):
		""" Returns a paged collection of CouponSets
		
		Args:
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a  pageSize  of 25, to get the 51st through the 75th items, use  startIndex=3 .
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The amount is divided and displayed on the  pageCount  amount of pages. The default is 20 and maximum value is 200 per page.
			| sortBy (string) - The element to sort the results by and the channel in which the results appear. Either ascending (a-z) or descending (z-a) channel. Optional.
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| includeCounts (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| CouponSetCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&includeCounts={includeCounts}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("includeCounts", includeCounts);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getCouponSet(self,couponSetCode, includeCounts = False, responseFields = None):
		""" 
		
		Args:
			| couponSetCode (string) - 
			| includeCounts (bool) - 
			| responseFields (string) - 
		
		Returns:
			| CouponSet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}?includeCounts={includeCounts}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		url.formatUrl("includeCounts", includeCounts);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getUniqueCouponSetCode(self,responseFields = None):
		""" Returns a random 4 character code that is unique as a coupon set code.
		
		Args:
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| string 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/unique-code?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addCouponSet(self,couponSet, responseFields = None):
		""" Adds a single
		
		Args:
			| couponSet(couponSet) - Mozu.ProductAdmin.Contracts.CouponSet ApiType DOCUMENT_HERE 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| CouponSet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(couponSet).execute();
		return self.client.result();

	
		
	def validateUniqueCouponSetCode(self,code):
		""" Tests code for uniqueness and validity
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/validate-unique-code", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		self.client.withResourceUrl(url).execute();

	
		
	def updateCouponSet(self,couponSet, couponSetCode, responseFields = None):
		""" 
		
		Args:
			| couponSet(couponSet) - 
			| couponSetCode (string) - 
			| responseFields (string) - 
		
		Returns:
			| CouponSet 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(couponSet).execute();
		return self.client.result();

	
		
	def deleteCouponSet(self,couponSetCode):
		""" 
		
		Args:
			| couponSetCode (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/couponsets/{couponSetCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("couponSetCode", couponSetCode);
		self.client.withResourceUrl(url).execute();

	
	
	