(function () {
    'use strict';

    if (!window.Avast) {
        window.Avast = {};
    }

    if (!Avast.handlers) {
        Avast.handlers = {};
    }

    if (!Avast.inputDB){
        Avast.inputDB={};
    }

    var enabled = false;

    Avast.handlers.enabled = function (msg, sender, callback) {
        callback(enabled);
    };

    Avast.handlers.inputdb = function(msg, sender,callback){

      Avast.inputDB=msg;

    };

    chrome.runtime.onMessage.addListener(function (msg, sender, callback) {

        if (!msg.type) {
            return;
        }

        var handler = Avast.handlers[msg.type];

        if (!handler) {
            return;
        }

        handler(msg.detail, sender, callback);

        return typeof callback !== 'undefined';
    });

    Avast.toggleEnabled=function () {
        
        enabled = !enabled;

        // broadcast to all tabs, all iframes
        chrome.tabs.query({}, function (tabs) {
            tabs.forEach(function (tab) {
                chrome.tabs.sendMessage(tab.id, { type: "enabled", detail: enabled });
            });
        });
        
        chrome.storage.local.set({ enabled: enabled });

        if (enabled) {
            chrome.browserAction.setIcon({ path: "img/icon48on.png" });
            chrome.browserAction.setTitle({ title: "Input Classifier is on" });

        }
        else {
            chrome.browserAction.setIcon({ path: "img/icon48off.png" });
            chrome.browserAction.setTitle({ title: "Input Classifier is off" });

        }
    };

    chrome.storage.local.get("enabled", function (settings) {
        if (typeof settings.enabled === "boolean") {
            enabled = !settings.enabled;
        }
        Avast.toggleEnabled();
    });

    chrome.browserAction.setPopup({ popup: "html/nativePopup.html"});
})();
