# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NotificationHubProperties(Model):
    """
    NotificationHub properties.

    :param name: The NotificationHub name.
    :type name: str
    :param registration_ttl: The RegistrationTtl of the created
     NotificationHub
    :type registration_ttl: str
    :param authorization_rules: The AuthorizationRules of the created
     NotificationHub
    :type authorization_rules: list of
     :class:`SharedAccessAuthorizationRuleProperties
     <azure.mgmt.notificationhubs.models.SharedAccessAuthorizationRuleProperties>`
    :param apns_credential: The ApnsCredential of the created NotificationHub
    :type apns_credential: :class:`ApnsCredential
     <azure.mgmt.notificationhubs.models.ApnsCredential>`
    :param wns_credential: The WnsCredential of the created NotificationHub
    :type wns_credential: :class:`WnsCredential
     <azure.mgmt.notificationhubs.models.WnsCredential>`
    :param gcm_credential: The GcmCredential of the created NotificationHub
    :type gcm_credential: :class:`GcmCredential
     <azure.mgmt.notificationhubs.models.GcmCredential>`
    :param mpns_credential: The MpnsCredential of the created NotificationHub
    :type mpns_credential: :class:`MpnsCredential
     <azure.mgmt.notificationhubs.models.MpnsCredential>`
    :param adm_credential: The AdmCredential of the created NotificationHub
    :type adm_credential: :class:`AdmCredential
     <azure.mgmt.notificationhubs.models.AdmCredential>`
    :param baidu_credential: The BaiduCredential of the created
     NotificationHub
    :type baidu_credential: :class:`BaiduCredential
     <azure.mgmt.notificationhubs.models.BaiduCredential>`
    """ 

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'registration_ttl': {'key': 'registrationTtl', 'type': 'str'},
        'authorization_rules': {'key': 'authorizationRules', 'type': '[SharedAccessAuthorizationRuleProperties]'},
        'apns_credential': {'key': 'apnsCredential', 'type': 'ApnsCredential'},
        'wns_credential': {'key': 'wnsCredential', 'type': 'WnsCredential'},
        'gcm_credential': {'key': 'gcmCredential', 'type': 'GcmCredential'},
        'mpns_credential': {'key': 'mpnsCredential', 'type': 'MpnsCredential'},
        'adm_credential': {'key': 'admCredential', 'type': 'AdmCredential'},
        'baidu_credential': {'key': 'baiduCredential', 'type': 'BaiduCredential'},
    }

    def __init__(self, name=None, registration_ttl=None, authorization_rules=None, apns_credential=None, wns_credential=None, gcm_credential=None, mpns_credential=None, adm_credential=None, baidu_credential=None):
        self.name = name
        self.registration_ttl = registration_ttl
        self.authorization_rules = authorization_rules
        self.apns_credential = apns_credential
        self.wns_credential = wns_credential
        self.gcm_credential = gcm_credential
        self.mpns_credential = mpns_credential
        self.adm_credential = adm_credential
        self.baidu_credential = baidu_credential
